/*
 * TremoloParser.hpp
 *
 *  Created on: Mar 2, 2010
 *      Author: metzler
 */

#ifndef TREMOLOPARSER_HPP_
#define TREMOLOPARSER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <string>
#include "Parser/FormatParser.hpp"

#include "TremoloKey.hpp"
#include "TremoloAtomInfoContainer.hpp"

class molecule;

/**
 * Loads a tremolo file into the World and saves the World as a tremolo file.
 */
class TremoloParser : public FormatParser
{
public:
  TremoloParser();
  ~TremoloParser();
  void load(std::istream* file);
  void save(std::ostream* file, const std::vector<atom *> &atoms);
  void setFieldsForSave(std::string atomDataLine);

  void parseKnownTypes(std::istream &file);
  void createKnownTypesByIdentity();


private:
  void readAtomDataLine(string line);
  void readAtomDataLine(string line, molecule *newmol);
  void parseAtomDataKeysLine(string line, int offset);
  void readNeighbors(std::stringstream* line, int numberOfNeighbors, int atomId);
  void processNeighborInformation();
  void adaptImprData();
  void adaptTorsion();
  std::string adaptIdDependentDataString(std::string data);
  bool isUsedField(std::string fieldName);
  void writeNeighbors(std::ostream* file, int numberOfNeighbors, atom* currentAtom);
  void saveLine(std::ostream* file, atom* currentAtom);

  /**
   * Map to associate the elements with stuff in "type", e.g. OC2 -> O.
   */
  std::map<std::string, std::string> knownTypes;

  /**
   * Map to associate the known keys with numbers.
   */
  std::map<std::string, TremoloKey::atomDataKey> knownKeys;

  /**
   * Inverse Map to have a name to each known keys.
   */
  std::map<TremoloKey::atomDataKey, std::string> knownKeyNames;

  /**
   * Fields used in the tremolo file.
   */
  std::vector<std::string> usedFields;

  /**
   * Data which is currently not stored in atoms but was provided by the input
   * file.
   */
  std::map<int, TremoloAtomInfoContainer> additionalAtomData;

  /**
   * Default additional atom data.
   */
  TremoloAtomInfoContainer defaultAdditionalData;

  /**
   * Maps original atom IDs received from the parsed file to atom IDs in the
   * world.
   */
  std::map<int, int> atomIdMap;
};

#endif /* TREMOLOPARSER_HPP_ */
