/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * TremoloAtomInfoContainer.cpp
 *
 *  Created on: Dec 7, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/toString.hpp"

#include <iostream>

#include "TremoloAtomInfoContainer.hpp"


TremoloAtomInfoContainer::TremoloAtomInfoContainer() :
  F("0"),
  stress("0"),
  imprData("-"),
  GroupMeasureTypeNo("0"),
  type("-"),
  extType("-"),
  name("-"),
  resName("-"),
  chainID("0"),
  resSeq("0"),
  occupancy("0"),
  tempFactor("0"),
  segID("0"),
  Charge("0"),
  charge("0"),
  GrpTypeNo("0"),
  torsion("-"),
  neighbors(std::vector<int>(0, 5)),
  neighbors_processed(false)
{}

void TremoloAtomInfoContainer::set(TremoloKey::atomDataKey key, std::string value) {
  switch (key) {
    case TremoloKey::F :
      F = value;
      break;
    case TremoloKey::stress :
      stress = value;
     break;
    case TremoloKey::imprData :
      imprData = value;
      break;
    case TremoloKey::GroupMeasureTypeNo :
      GroupMeasureTypeNo = value;
      break;
    case TremoloKey::type :
      type = value;
      break;
    case TremoloKey::extType :
      extType = value;
      break;
    case TremoloKey::name :
      name = value;
      break;
    case TremoloKey::resName :
      resName = value;
      break;
    case TremoloKey::chainID :
      chainID = value;
      break;
    case TremoloKey::resSeq :
      resSeq = value;
      break;
    case TremoloKey::occupancy :
      occupancy = value;
      break;
    case TremoloKey::tempFactor :
      tempFactor = value;
      break;
    case TremoloKey::segID :
      segID = value;
      break;
    case TremoloKey::Charge :
      Charge = value;
      break;
    case TremoloKey::charge :
      charge = value;
      break;
    case TremoloKey::GrpTypeNo :
      GrpTypeNo = value;
      break;
    case TremoloKey::torsion :
      torsion = value;
      break;
    case TremoloKey::noKey :
      break;
    default :
      std::cout << "Unknown key: " << key << ", value: " << value << std::endl;
      break;
  }
}

std::string TremoloAtomInfoContainer::get(TremoloKey::atomDataKey key) const
{
  switch (key) {
    case TremoloKey::F :
      return F;
    case TremoloKey::stress :
      return stress;
    case TremoloKey::imprData :
      return imprData;
    case TremoloKey::GroupMeasureTypeNo :
      return GroupMeasureTypeNo;
    case TremoloKey::type :
      return type;
    case TremoloKey::extType :
      return extType;
    case TremoloKey::name :
      return name;
    case TremoloKey::resName :
      return resName;
    case TremoloKey::chainID :
      return chainID;
    case TremoloKey::resSeq :
      return resSeq;
    case TremoloKey::occupancy :
      return occupancy;
    case TremoloKey::tempFactor :
      return tempFactor;
    case TremoloKey::segID :
      return segID;
    case TremoloKey::Charge :
      return Charge;
    case TremoloKey::charge :
      return charge;
    case TremoloKey::GrpTypeNo :
      return GrpTypeNo;
    case TremoloKey::torsion :
      return torsion;
    case TremoloKey::noKey :
      return std::string("noKey"); // warning string
    default :
      std::cout << "Unknown key: " << key << std::endl;
      return "";
  }
}

std::ostream& operator<<(std::ostream& out, const TremoloAtomInfoContainer& info)
{
  out << info.get(TremoloKey::F) << "\t";
  out << info.get(TremoloKey::stress) << "\t";
  out << info.get(TremoloKey::imprData) << "\t";
  out << info.get(TremoloKey::GroupMeasureTypeNo) << "\t";
  out << info.get(TremoloKey::type) << "\t";
  out << info.get(TremoloKey::extType) << "\t";
  out << info.get(TremoloKey::name) << "\t";
  out << info.get(TremoloKey::resName) << "\t";
  out << info.get(TremoloKey::chainID) << "\t";
  out << info.get(TremoloKey::resSeq) << "\t";
  out << info.get(TremoloKey::occupancy) << "\t";
  out << info.get(TremoloKey::tempFactor) << "\t";
  out << info.get(TremoloKey::segID) << "\t";
  out << info.get(TremoloKey::Charge) << "\t";
  out << info.get(TremoloKey::charge) << "\t";
  out << info.get(TremoloKey::GrpTypeNo) << "\t";
  out << info.get(TremoloKey::torsion) << "\t";
  out << info.neighbors << "\t";
  out << info.neighbors_processed;

  return out;
}
