/*
 * AnalysisPairCorrelationUnitTest.cpp
 *
 *  Created on: Oct 13, 2009
 *      Author: heber
 */

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include <cstring>

#include "analysis_correlation.hpp"
#include "AnalysisPairCorrelationUnitTest.hpp"

#include "Descriptors/MoleculeDescriptor.hpp"

#include "World.hpp"
#include "atom.hpp"
#include "boundary.hpp"
#include "element.hpp"
#include "molecule.hpp"
#include "linkedcell.hpp"
#include "periodentafel.hpp"
#include "tesselation.hpp"
#include "World.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( AnalysisPairCorrelationUnitTest );


void AnalysisPairCorrelationUnitTest::setUp()
{
  atom *Walker = NULL;

  // init private all pointers to zero
  TestMolecule = NULL;
  correlationmap = NULL;
  binmap = NULL;

  // construct element list
  std::vector<element *> elements;
  hydrogen = World::getInstance().getPeriode()->FindElement(1);
  CPPUNIT_ASSERT(hydrogen != NULL && "hydrogen element not found");
  elements.push_back(hydrogen);
  elements.push_back(hydrogen);

  // construct molecule (tetraeder of hydrogens)
  TestMolecule = World::getInstance().createMolecule();
  Walker = World::getInstance().createAtom();
  Walker->setType(hydrogen);
  Walker->setPosition(Vector(1., 0., 1. ));
  TestMolecule->AddAtom(Walker);
  Walker = World::getInstance().createAtom();
  Walker->setType(hydrogen);
  Walker->setPosition(Vector(0., 1., 1. ));
  TestMolecule->AddAtom(Walker);
  Walker = World::getInstance().createAtom();
  Walker->setType(hydrogen);
  Walker->setPosition(Vector(1., 1., 0. ));
  TestMolecule->AddAtom(Walker);
  Walker = World::getInstance().createAtom();
  Walker->setType(hydrogen);
  Walker->setPosition(Vector(0., 0., 0. ));
  TestMolecule->AddAtom(Walker);

  // check that TestMolecule was correctly constructed
  CPPUNIT_ASSERT_EQUAL( TestMolecule->getAtomCount(), 4 );

  // init maps
  World::getInstance().selectAllMolecules(AllMolecules());
  allMolecules = World::getInstance().getSelectedMolecules();
  CPPUNIT_ASSERT_EQUAL( (size_t) 1, allMolecules.size());
  correlationmap = PairCorrelation( allMolecules, elements);
  binmap = NULL;

};


void AnalysisPairCorrelationUnitTest::tearDown()
{
  if (correlationmap != NULL)
    delete(correlationmap);
  if (binmap != NULL)
    delete(binmap);

  // note that all the atoms are cleaned by TestMolecule
  World::purgeInstance();
  logger::purgeInstance();
  errorLogger::purgeInstance();
};

void AnalysisPairCorrelationUnitTest::PairCorrelationTest()
{
  // do the pair correlation
  CPPUNIT_ASSERT( correlationmap != NULL );
  CPPUNIT_ASSERT_EQUAL( (size_t)6, correlationmap->size() );
};

void AnalysisPairCorrelationUnitTest::PairCorrelationBinNoRangeTest()
{
  BinPairMap::iterator tester;
  // put pair correlation into bins and check with no range
  binmap = BinData( correlationmap, 0.5, 0., 0. );
  CPPUNIT_ASSERT_EQUAL( (size_t)1, binmap->size() );
  //OutputCorrelation ( binmap );
  tester = binmap->begin();
  CPPUNIT_ASSERT_EQUAL( sqrt(2.), tester->first );
  CPPUNIT_ASSERT_EQUAL( 6, tester->second );
};

void AnalysisPairCorrelationUnitTest::PairCorrelationBinRangeTest()
{
  BinPairMap::iterator tester;
  // ... and check with [0., 2.] range
  binmap = BinData( correlationmap, 0.5, 0., 2. );
  CPPUNIT_ASSERT_EQUAL( (size_t)5, binmap->size() );
  //OutputCorrelation ( binmap );
  tester = binmap->begin();
  CPPUNIT_ASSERT_EQUAL( 0., tester->first );
  tester = binmap->find(1.);
  CPPUNIT_ASSERT_EQUAL( 1., tester->first );
  CPPUNIT_ASSERT_EQUAL( 6, tester->second );
};
