#ifndef BOUNDARY_HPP_
#define BOUNDARY_HPP_

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <fstream>
#include <iosfwd>

// STL headers
#include <map>

#include "LinearAlgebra/defs.hpp"
#include "BoundaryMaps.hpp"

/****************************************** forward declarations *****************************/

class BoundaryPointSet;
class BoundaryLineSet;
class BoundaryTriangleSet;
class config;
class LinkedCell_deprecated;
class molecule;
class Tesselation;
class TesselPoint;
class Vector;

/********************************************** definitions *********************************/

enum { DEBUG=1 };
enum { DoSingleStepOutput=0 };
enum { SingleStepWidth=10 };

/********************************************** declarations *******************************/

double ConvexizeNonconvexEnvelope(class Tesselation *&TesselStruct, const molecule * const mol, const char * const filename, bool DebugOutputEveryStep = false);
void FindConvexBorder(const molecule* const mol, Boundaries *BoundaryPts, Tesselation *&TesselStruct, const LinkedCell_deprecated *LCList, const char *filename);
bool FindNonConvexBorder(molecule* const mol, Tesselation *&TesselStruct, const LinkedCell_deprecated *&LC, const double RADIUS, const char *tempbasename);
Boundaries *GetBoundaryPoints(const molecule *mol, Tesselation *&TesselStruct);
double * GetDiametersOfCluster(const Boundaries *BoundaryPtr, const molecule *mol, Tesselation *&TesselStruct, const bool IsAngstroem);
bool RemoveAllBoundaryPoints(class Tesselation *&TesselStruct, const molecule * const mol, const char * const filename);
void StoreTrianglesinFile(const molecule * const mol, const Tesselation * const TesselStruct, const char *filename, const char *extraSuffix);


#endif /*BOUNDARY_HPP_*/
