/*
 * QtTimeLine.hpp
 *
 *  Created on: Jul 11, 2013
 *      Author: heber
 */

#ifndef QTTIMELINE_HPP_
#define QTTIMELINE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QtGui/QSlider>
#include "CodePatterns/Observer/Observer.hpp"

class QtTimeLine : public QSlider, public Observer
{
  Q_OBJECT

public:
  QtTimeLine(QWidget * _parent=0);
  virtual ~QtTimeLine();

protected:
  virtual void update(Observable *publisher);
  virtual void recieveNotification(Observable *publisher, Notification_ptr notification);
  virtual void subjectKilled(Observable *publisher);

private slots:
  void StepUpdate(int position);

private:
  //!> whether AtomObserver knows about us or not
  bool atomobserver_enlisted;
  //!> whether WorldTime knows about us or not
  bool worldtime_enlisted;
};

#endif /* QTTIMELINE_HPP_ */
