/*
 * UIFactory.hpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

#ifndef UIFACTORY_HPP_
#define UIFACTORY_HPP_

class MainWindow;
class Dialog;

class MoleculeListClass;
class config;
class periodentafel;

struct menuPopulaters;

class UIFactory
{

public:
  enum InterfaceTypes {
    Text,
#ifdef USE_GUI_QT
    QT4
#endif
};
  virtual ~UIFactory();

  // methods for creating UIElements
  virtual MainWindow* makeMainWindow(menuPopulaters,MoleculeListClass *, config *, periodentafel *, char *)=0;
  virtual Dialog* makeDialog()=0;

protected:
  UIFactory();

// singleton stuff
private:
  static UIFactory *theFactory;

public:
  static void makeUserInterface(InterfaceTypes type);
  static UIFactory* get();
  static void purgeInstance();
};

#endif /* UIFACTORY_HPP_ */
