/*
 * Dialog.hpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

#ifndef DIALOG_HPP_
#define DIALOG_HPP_

#include<string>
#include<list>

class MoleculeListClass;
class molecule;
class Vector;
class element;

class Dialog
{
public:
  Dialog();
  virtual ~Dialog();

  virtual void queryInt(const char *, int *)=0;
  virtual void queryDouble(const char*,double *)=0;
  virtual void queryString(const char*, std::string *)=0;
  virtual void queryMolecule(const char*,molecule**,MoleculeListClass*)=0;
  virtual void queryVector(const char*,Vector *,const double *const,bool)=0;
  virtual void queryElement(const char*,element **)=0;

  virtual bool display();

  virtual bool checkAll();
  virtual void setAll();

protected:
  // methodology for handling queries
  // all queries are stored and then performed at appropriate times

  //these queries can be handled by this dialog

  //TODO: Find a way to reduce complexity...
  //needs O(N*M) query classes, where N is the number of query types and M is the number of GUIs
  //usual approach for reducing inheritance complexity (strategy pattern) does not work,
  //due to lack of common code for query types as well as GUI-Types (all subtypes differ a lot)

  //base class for all queries
  class Query {
  public:
    Query(std::string _title);
    virtual ~Query();
    virtual bool handle()=0;
    virtual void setResult()=0;
  protected:
    const std::string getTitle() const;
  private:
    std::string title;
  };

  //Specialized classes for certain types. GUI-Types are not specialized at this time
  class IntQuery : public Query {
  public:
    IntQuery(std::string title,int *_target);
    virtual ~IntQuery();
    virtual bool handle()=0;
    virtual void setResult();
  protected:
    int tmp;
  private:
    int *target;
  };

  class DoubleQuery : public Query {
  public:
    DoubleQuery(std::string title,double *_target);
    virtual ~DoubleQuery();
    virtual bool handle()=0;
    virtual void setResult();
  protected:
    double tmp;
  private:
    double *target;
  };

  class StringQuery : public Query {
  public:
    StringQuery(std::string title,std::string *_target);
    virtual ~StringQuery();
    virtual bool handle()=0;
    virtual void setResult();
  protected:
    std::string tmp;
  private:
    std::string *target;
  };


  class MoleculeQuery : public Query {
  public:
    MoleculeQuery(std::string title, molecule **_target, MoleculeListClass *_molecules);
    virtual ~MoleculeQuery();
    virtual bool handle()=0;
    virtual void setResult();
  protected:
    molecule *tmp;
    MoleculeListClass *molecules;
  private:
    molecule **target;
  };

  class VectorQuery : public Query {
  public:
      VectorQuery(std::string title,Vector *_target,const double *const _cellSize,bool _check);
      virtual ~VectorQuery();
      virtual bool handle()=0;
      virtual void setResult();
    protected:
      Vector *tmp;
      const double *const cellSize;
      bool check;
    private:
      Vector *target;
  };

  class ElementQuery : public Query {
  public:
    ElementQuery(std::string title, element**_target);
    virtual ~ElementQuery();
    virtual bool handle()=0;
    virtual void setResult();
  protected:
    element *tmp;
  private:
    element **target;
  };

void registerQuery(Query* query);

private:
  std::list<Query*> queries;

};

#endif /* DIALOG_HPP_ */
