/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * PotentialTypeValidator.cpp
 *
 *  Created on: Apr 09, 2013
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "PotentialTypeValidator.hpp"

#include "Potentials/PotentialFactory.hpp"
#include "Potentials/Specifics/PotentialTypes.hpp"

PotentialTypeValidator::PotentialTypeValidator() :
DiscreteValidator<std::string>(std::vector<std::string>())
{
  // add all names from factory
  const PotentialFactory &factory = PotentialFactory::getInstance();
  for (PotentialTypes t = PotentialTypes_begin;
      t != PotentialTypes_end; ++ t) {
    PotentialFactory::TypeToName_t::const_iterator it = factory.TypeToName.find(t);
    const std::string &name = it->second;
    appendValidValue(name);
  }
}




