/*
 * UniqueFragments.hpp
 *
 *  Created on: Oct 18, 2011
 *      Author: heber
 */

#ifndef UNIQUEFRAGMENTS_HPP_
#define UNIQUEFRAGMENTS_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <list>
#include <vector>

#include "graph.hpp"

class atom;
class bond;
class config;

/** Structure containing all values in power set combination generation.
 */
class UniqueFragments
{
public:
  UniqueFragments();
  ~UniqueFragments();

  void InsertFragmentIntoGraph(); // Insert a KeySet into a Graph
  void Init(atom *_Root);
  void Cleanup();

  atom * const getRoot() const;
  void setRoot(atom *_root);

  void PrepareForPowersetGeneration(double _TEFactor, Graph *_Leaflet, atom *_Root);

  KeySet *FragmentSet;
  int FragmentCounter;

private:
  atom *Root;
  double TEFactor;
  Graph *Leaflet;

private:
  int ANOVAOrder;
  int CurrentIndex;
  bool **UsedList;
};


#endif /* UNIQUEFRAGMENTS_HPP_ */
