/*
 * PowerSetGenerator.hpp
 *
 *  Created on: Oct 18, 2011
 *      Author: heber
 */

#ifndef POWERSETGENERATOR_HPP_
#define POWERSETGENERATOR_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <list>
#include <vector>

#include "Fragmentation/BondsPerShortestPath.hpp"
#include "graph.hpp"

class bond;
class UniqueFragment;

class PowerSetGenerator
{
public:
  PowerSetGenerator(UniqueFragments *_FragmentSearch, int Order);
  ~PowerSetGenerator();

  void SPFragmentGenerator(int RootDistance, std::vector<bond *> &BondsSet, int SetDimension, int SubOrder);
  int operator()(KeySet &RestrictedKeySet);
  void RemoveAllTouchedFromSnakeStack(int verbosity, KeySet *FragmentSet, int *&TouchedList, int &TouchedIndex);
  int FillBondsList(std::vector<bond *> &BondsList, std::list<bond *>::const_iterator SetFirst, std::list<bond *>::const_iterator SetLast, int *&TouchedList, int TouchedIndex);
  int CountSetMembers(std::list<bond *>::const_iterator SetFirst, std::list<bond *>::const_iterator SetLast, int *&TouchedList, int TouchedIndex);
  int AddPowersetToSnakeStack(int verbosity, int CurrentCombination, int SetDimension, KeySet *FragmentSet, std::vector<bond *> &BondsSet, int *&TouchedList, int &TouchedIndex);
  void ClearingTouched(int verbosity, int *&TouchedList, int SubOrder, int &TouchedIndex);

private:
  BondsPerShortestPath BondsPerSPList;

  class UniqueFragments *FragmentSearch;
};


#endif /* POWERSETGENERATOR_HPP_ */
