/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2016 Frederik Heber. All rights reserved.
 *
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * BindingModel.cpp
 *
 *  Created on: Oct 5, 2016
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

#include "Potentials/BindingModel.hpp"

#include <iostream>

#include "CodePatterns/toString.hpp"

static HomologyGraph::nodes_t getMapOfNodes(const BindingModel::vector_nodes_t &_nodes)
{
  HomologyGraph::nodes_t returnnodes;
  for (BindingModel::vector_nodes_t::const_iterator iter = _nodes.begin();
      iter != _nodes.end(); ++iter) {
    std::pair<HomologyGraph::nodes_t::iterator, bool > inserter;
    inserter = returnnodes.insert( std::make_pair(*iter, 1) );
    if (!inserter.second)
      ++(inserter.first->second);
  }
  return returnnodes;
}

BindingModel::BindingModel(
    const BindingModel::vector_nodes_t &_nodes,
    const HomologyGraph::edges_t &_edges) :
  graph(getMapOfNodes(_nodes), _edges),
  nodes(_nodes)
{}

bool BindingModel::operator<(const BindingModel &model) const {
  if (graph.getEdges().empty()) {
    return nodes < model.nodes;
  } else
    return graph.getEdges() < model.graph.getEdges();
}

bool BindingModel::operator>(const BindingModel &model) const  {
  if (graph.getEdges().empty()) {
    return nodes > model.nodes;
  } else
    return graph.getEdges() > model.graph.getEdges();
}

bool BindingModel::operator==(const BindingModel &model) const {
  if (graph.getEdges().empty()) {
    return nodes == model.nodes;
  } else
    return graph.getEdges() == model.graph.getEdges();
}

std::ostream& operator<<(std::ostream& ost, const BindingModel &model) {
  model.getGraph().printEdges(ost);
  ost << ", " << model.getNodes();
  return ost;
}
