/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * MoleculeSelectionDescriptor.cpp
 *
 *  Created on: Jul 16, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Descriptors/MoleculeSelectionDescriptor.hpp"
#include "Descriptors/MoleculeSelectionDescriptor_impl.hpp"

#include "Helpers/helpers.hpp"

MoleculeSelectionDescriptor_impl::MoleculeSelectionDescriptor_impl(){}

MoleculeSelectionDescriptor_impl::~MoleculeSelectionDescriptor_impl(){}

bool MoleculeSelectionDescriptor_impl::predicate(std::pair<moleculeId_t,molecule*> molecule){
  return getSelectedMolecules().count(molecule.first);
}

molecule* MoleculeSelectionDescriptor_impl::find(){
  World::MoleculeSet &set = getSelectedMolecules();
  World::MoleculeSet::internal_iterator begin = set.begin_internal();
  return (begin!=set.end_internal())?(begin->second):0;
}

std::vector<molecule*> MoleculeSelectionDescriptor_impl::findAll(){
  std::vector<molecule*> res;
  World::MoleculeSet &set = getSelectedMolecules();
  transform(set.begin_internal(),
           set.end_internal(),
           back_inserter(res),
           _take<molecule*,World::MoleculeSet::value_type>::get);
  return res;
}

World::MoleculeSet& MoleculeSelectionDescriptor_impl::getSelectedMolecules(){
  return World::getInstance().selectedMolecules;
}

MoleculeDescriptor MoleculesBySelection(){
  return MoleculeDescriptor(MoleculeDescriptor::impl_ptr(new MoleculeSelectionDescriptor_impl()));
}
