/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * SaveAdjacencyAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>
#include <fstream>
#include <string>

#include "CodePatterns/Log.hpp"
#include "Graph/AdjacencyList.hpp"
#include "molecule.hpp"
#include "World.hpp"

#include "Actions/MoleculeAction/SaveAdjacencyAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "SaveAdjacencyAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr MoleculeSaveAdjacencyAction::performCall() {
  molecule *mol = NULL;

  // gather all desired ids
  typedef std::vector<atomId_t> atomids_t;
  atomids_t atomids;
  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    mol = iter->second;
    const molecule::atomIdSet &mol_atomids = mol->getAtomIds();
    atomids.insert(atomids.end(), mol_atomids.begin(), mol_atomids.end());
  }

  // store to file
  AdjacencyList adjacency(atomids);
  std::ofstream AdjacencyFile;
  const std::string filename = params.adjacencyfile.get().string();
  LOG(0, "STATUS: Storing adjacency of selected molecules to " << filename << ".");
  AdjacencyFile.open(filename.c_str(), ios::out);
  adjacency.StoreToFile(AdjacencyFile);
  AdjacencyFile.close();

  return Action::success;
}

Action::state_ptr MoleculeSaveAdjacencyAction::performUndo(Action::state_ptr _state) {
//  MoleculeSaveAdjacencyState *state = assert_cast<MoleculeSaveAdjacencyState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeSaveAdjacencyAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeSaveAdjacencyAction::canUndo() {
  return false;
}

bool MoleculeSaveAdjacencyAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
