/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * DepthFirstSearchAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Atom/atom.hpp"
#include "CodePatterns/Log.hpp"
#include "Fragmentation/HydrogenSaturation_enum.hpp"
#include "Graph/CyclicStructureAnalysis.hpp"
#include "Graph/DepthFirstSearchAnalysis.hpp"
#include "Graph/ListOfLocalAtoms.hpp"
#include "molecule.hpp"
#include "MoleculeLeafClass.hpp"

#include <iostream>
#include <string>

#include "Actions/GraphAction/DepthFirstSearchAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "DepthFirstSearchAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr GraphDepthFirstSearchAction::performCall() {
  LOG(1, "Depth-First-Search Analysis.");
  ListOfLocalAtoms_t ListOfAtoms;
  std::deque<bond *> *LocalBackEdgeStack = NULL;
  DepthFirstSearchAnalysis DFS;
  DFS();
  DFS.UpdateMoleculeStructure();
  MoleculeLeafClass *Subgraphs = DFS.getMoleculeStructure();
  if (Subgraphs != NULL) {
    int FragmentCounter = 0;
    while (Subgraphs->next != NULL) {
      Subgraphs = Subgraphs->next;
      ListOfAtoms.clear();
      Subgraphs->Leaf->FillListOfLocalAtoms(ListOfAtoms, Subgraphs->Leaf->getAtomCount());
      LocalBackEdgeStack = new std::deque<bond *>; // no need to have it Subgraphs->Leaf->BondCount size
      DFS.PickLocalBackEdges(ListOfAtoms, LocalBackEdgeStack);
      CyclicStructureAnalysis CycleAnalysis(params.DoSaturation.get() ? DoSaturate : DontSaturate);
      CycleAnalysis(LocalBackEdgeStack);
      delete(LocalBackEdgeStack);
      Subgraphs->Leaf = NULL;
      delete(Subgraphs->previous);
      FragmentCounter++;
    }
    Subgraphs->Leaf = NULL;
    delete(Subgraphs);
  }
  return Action::success;
}

Action::state_ptr GraphDepthFirstSearchAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr GraphDepthFirstSearchAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool GraphDepthFirstSearchAction::canUndo() {
  return true;
}

bool GraphDepthFirstSearchAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
