/*
 * Woodcock.hpp
 *
 *  Created on: Aug 20, 2010
 *      Author: crueger
 */

#ifndef WOODCOCK_HPP_
#define WOODCOCK_HPP_

#include "Thermostats/Thermostat.hpp"

class Woodcock : public Thermostat
{
public:
  Woodcock(int,double);
  virtual ~Woodcock();

  virtual double scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::list));
  virtual double scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::vector));
  virtual double scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::set));

  virtual std::string name(){return "Woodcock";}

private:
  template <class ForwardIterator>
  double doScaleAtoms(config &configuration,unsigned int step,ForwardIterator begin,ForwardIterator end);

  int MDSteps;
  double ActualTemp;
};

#endif /* WOODCOCK_HPP_ */
