/*
 * Woodcock.cpp
 *
 *  Created on: Aug 20, 2010
 *      Author: crueger
 */

#include "Woodcock.hpp"

#include "element.hpp"
#include "config.hpp"
#include "Helpers/Verbose.hpp"
#include "Helpers/Log.hpp"
#include "ThermoStatContainer.hpp"

Woodcock::Woodcock(int _MDSteps, double _ActualTemp) :
  MDSteps(_MDSteps),
  ActualTemp(_ActualTemp)
{}

Woodcock::~Woodcock()
{}

double Woodcock::scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::list) atoms){
  return doScaleAtoms(configuration,step,atoms.begin(),atoms.end());
}

double Woodcock::scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::vector) atoms){
  return doScaleAtoms(configuration,step,atoms.begin(),atoms.end());
}

double Woodcock::scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::set) atoms){
  return doScaleAtoms(configuration,step,atoms.begin(),atoms.end());
}

template <class ForwardIterator>
double Woodcock::doScaleAtoms(config &configuration,unsigned int step,ForwardIterator begin,ForwardIterator end){
  double ekin=0;
  if ((configuration.Thermostats->ScaleTempStep > 0) && ((MDSteps-1) % configuration.Thermostats->ScaleTempStep == 0)) {
    double ScaleTempFactor = sqrt(configuration.Thermostats->TargetTemp/ActualTemp);
    DoLog(2) && (Log() << Verbose(2) <<  "Applying Woodcock thermostat..." << endl);
    double ekin;
    for (ForwardIterator iter = begin; iter!=end;++iter){
      Vector &U = (*iter)->Trajectory.U.at(step);
      if ((*iter)->FixedIon == 0){ // even FixedIon moves, only not by other's forces
        U *= ScaleTempFactor;
        ekin += 0.5*(*iter)->getType()->mass * U.NormSquared();
      }
    }
  }
  return ekin;
}
