/*
 * Thermostat.hpp
 *
 *  Created on: Aug 18, 2010
 *      Author: crueger
 */

#ifndef THERMOSTAT_HPP_
#define THERMOSTAT_HPP_

class config;

#include <string>
#include <set>
#include <vector>
#include <list>
#include "AtomSet.hpp"

class Thermostat
{
public:
  Thermostat();
  virtual  ~Thermostat();

  // cannot template this, because we need virtual functions
  virtual double scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::list))=0;
  virtual double scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::vector))=0;
  virtual double scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::set))=0;

  virtual std::string name()=0;
};

#endif /* THERMOSTAT_HPP_ */
