/*
 * NoseHoover.hpp
 *
 *  Created on: Aug 20, 2010
 *      Author: crueger
 */

#ifndef NOSEHOOVER_HPP_
#define NOSEHOOVER_HPP_

#include "Thermostats/Thermostat.hpp"

class NoseHoover : public Thermostat
{
public:
  NoseHoover();
  virtual ~NoseHoover();

  virtual double scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::list));
  virtual double scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::vector));
  virtual double scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::set));

  virtual std::string name() { return "Nose-Hoover";}

private:
  template <class ForwardIterator>
  void init(unsigned int step,ForwardIterator begin, ForwardIterator end);
  template <class ForwardIterator>
  double doScaleAtoms(config &configuration,unsigned int step,ForwardIterator begin, ForwardIterator end);

  double delta_alpha;
  int count;
};

#endif /* NOSEHOOVER_HPP_ */
