/*
 * NoseHoover.cpp
 *
 *  Created on: Aug 20, 2010
 *      Author: crueger
 */

#include "NoseHoover.hpp"

#include "element.hpp"
#include "config.hpp"
#include "Helpers/Verbose.hpp"
#include "Helpers/Log.hpp"
#include "ThermoStatContainer.hpp"

NoseHoover::NoseHoover()
{}

NoseHoover::~NoseHoover()
{}


double NoseHoover::scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::list) atoms){
  return doScaleAtoms(configuration,step,atoms.begin(),atoms.end());
}

double NoseHoover::scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::vector) atoms){
  return doScaleAtoms(configuration,step,atoms.begin(),atoms.end());
}

double NoseHoover::scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::set) atoms){
  return doScaleAtoms(configuration,step,atoms.begin(),atoms.end());
}

template <class ForwardIterator>
double NoseHoover::doScaleAtoms(config &configuration,unsigned int step,ForwardIterator begin, ForwardIterator end){
  DoLog(2) && (Log() << Verbose(2) <<  "Applying Nose-Hoover thermostat..." << endl);
  init(step,begin,end);
  delta_alpha = (delta_alpha - (3.*count+1.) * configuration.Thermostats->TargetTemp)/(configuration.Thermostats->HooverMass*Units2Electronmass);
  configuration.Thermostats->alpha += delta_alpha*configuration.Deltat;
  DoLog(3) && (Log() << Verbose(3) << "alpha = " << delta_alpha << " * " << configuration.Deltat << " = " << configuration.Thermostats->alpha << "." << endl);
  double ekin =0;
  for(ForwardIterator iter=begin;iter!=end;++iter){
    Vector &U = (*iter)->Trajectory.U.at(step);
    if ((*iter)->FixedIon == 0) { // even FixedIon moves, only not by other's forces
      U += configuration.Deltat/(*iter)->getType()->mass * (configuration.Thermostats->alpha * (U * (*iter)->getType()->mass));
      ekin += (0.5*(*iter)->getType()->mass) * U.NormSquared();
    }
  }
  return ekin;
}

template <class ForwardIterator>
void NoseHoover::init(unsigned int step,ForwardIterator begin, ForwardIterator end){
  delta_alpha=0;
  count=0;
  for(ForwardIterator iter = begin;iter!=end;++iter){
    Vector &U = (*iter)->Trajectory.U.at(step);
    if ((*iter)->FixedIon == 0) { // even FixedIon moves, only not by other's forces
      delta_alpha += U.NormSquared()*(*iter)->getType()->mass;
    }
    ++count;
  }
}
