/*
 * Langevin.hpp
 *
 *  Created on: Aug 20, 2010
 *      Author: crueger
 */

#ifndef LANGEVIN_HPP_
#define LANGEVIN_HPP_

#include "Thermostats/Thermostat.hpp"

class Langevin : public Thermostat
{
public:
  Langevin();
  virtual ~Langevin();

  virtual double scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::list))=0;
  virtual double scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::vector))=0;
  virtual double scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::set))=0;

  virtual std::string name(){return "Langevin";}

private:
  template <class ForwardIterator>
  double doScaleAtoms(config &configuration,unsigned int step,ForwardIterator begin, ForwardIterator end);

  gsl_rng * r;
  const gsl_rng_type * T;
};

#endif /* LANGEVIN_HPP_ */
