/*
 * Langevin.cpp
 *
 *  Created on: Aug 20, 2010
 *      Author: crueger
 */

#include "Langevin.hpp"
#include "element.hpp"
#include "config.hpp"
#include "Helpers/Verbose.hpp"
#include "Helpers/Log.hpp"
#include "ThermoStatContainer.hpp"

Langevin::Langevin()
{
  gsl_rng_env_setup();
  T = gsl_rng_default;
  r = gsl_rng_alloc (T);
}

Langevin::~Langevin()
{
  gsl_rng_free (r);
}

double Langevin::scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::list) atoms){
  return doScaleAtoms(configuration,step,atoms.begin(),atoms.end());
}

double Langevin::scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::vector) atoms){
  return doScaleAtoms(configuration,step,atoms.begin(),atoms.end());
}

double Langevin::scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::set) atoms){
  return doScaleAtoms(configuration,step,atoms.begin(),atoms.end());
}

template <class ForwardIterator>
double Langevin::doScaleAtoms(config &configuration,unsigned int step,ForwardIterator begin, ForwardIterator end){
  DoLog(2) && (Log() << Verbose(2) <<  "Applying Langevin thermostat..." << endl);
  double ekin=0;
  for(ForwardIterator iter=begin;iter!=end;++iter){
    double sigma  = sqrt(configuration.Thermostats->TargetTemp/(*iter)->getType()->mass); // sigma = (k_b T)/m (Hartree/atomicmass = atomiclength/atomictime)
    Vector &U = (*iter)->Trajectory.U.at(step);
    if ((*iter)->FixedIon == 0) { // even FixedIon moves, only not by other's forces
      // throw a dice to determine whether it gets hit by a heat bath particle
      if (((((rand()/(double)RAND_MAX))*configuration.Thermostats->TempFrequency) < 1.)) {
        DoLog(3) && (Log() << Verbose(3) << "Particle " << (**iter) << " was hit (sigma " << sigma << "): " << sqrt(U[0]*U[0]+U[1]*U[1]+U[2]*U[2]) << " -> ");
        // pick three random numbers from a Boltzmann distribution around the desired temperature T for each momenta axis
        for (int d=0; d<NDIM; d++) {
          U[d] = gsl_ran_gaussian (r, sigma);
        }
        DoLog(2) && (Log() << Verbose(2) << sqrt(U[0]*U[0]+U[1]*U[1]+U[2]*U[2]) << endl);
      }
      ekin += 0.5*(*iter)->getType()->mass * U.NormSquared();
    }
  }
  return ekin;
}
