/*
 * GaussianThermostat.hpp
 *
 *  Created on: Aug 18, 2010
 *      Author: crueger
 */

#ifndef GAUSSIANTHERMOSTAT_HPP_
#define GAUSSIANTHERMOSTAT_HPP_

#include "Thermostats/Thermostat.hpp"

class config;

class GaussianThermostat : public Thermostat
{
public:
  GaussianThermostat();
  virtual ~GaussianThermostat();

  virtual double scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::list));
  virtual double scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::vector));
  virtual double scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::set));

  virtual std::string name() { return "Gaussian";}
  double getE() const;
  double getG() const;
private:
  template <class ForwardIterator>
  void init(unsigned int step,ForwardIterator begin, ForwardIterator end);
  template <class ForwardIterator>
  double doScaleAtoms(config &configuration,unsigned int step,ForwardIterator begin, ForwardIterator end);
  double E,G;
};

#endif /* GAUSSIANTHERMOSTAT_HPP_ */
