/*
 * Berendsen.hpp
 *
 *  Created on: Aug 20, 2010
 *      Author: crueger
 */

#ifndef BERENDSEN_HPP_
#define BERENDSEN_HPP_

#include "Thermostats/Thermostat.hpp"

class Berendsen : public Thermostat
{
public:
  Berendsen(double);
  virtual ~Berendsen();

  virtual double scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::list));
  virtual double scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::vector));
  virtual double scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::set));

  virtual std::string name() { return "Berendsen";}
private:
  template <class ForwardIterator>
  double doScaleAtoms(config &configuration,unsigned int step,ForwardIterator begin, ForwardIterator end);

  double ActualTemp;
};

#endif /* BERENDSEN_HPP_ */
