/*
 * Berendsen.cpp
 *
 *  Created on: Aug 20, 2010
 *      Author: crueger
 */

#include "Berendsen.hpp"
#include "element.hpp"
#include "config.hpp"
#include "Helpers/Verbose.hpp"
#include "Helpers/Log.hpp"
#include "ThermoStatContainer.hpp"

Berendsen::Berendsen(double _ActualTemp) :
  ActualTemp(_ActualTemp)
{}

Berendsen::~Berendsen()
{}

double Berendsen::scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::list) atoms){
  return doScaleAtoms(configuration,step,atoms.begin(),atoms.end());
}

double Berendsen::scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::vector) atoms){
  return doScaleAtoms(configuration,step,atoms.begin(),atoms.end());
}

double Berendsen::scaleAtoms(config &configuration,unsigned int step,ATOMSET(std::set) atoms){
  return doScaleAtoms(configuration,step,atoms.begin(),atoms.end());
}

template <class ForwardIterator>
double Berendsen::doScaleAtoms(config &configuration,unsigned int step,ForwardIterator begin, ForwardIterator end){
  DoLog(2) && (Log() << Verbose(2) <<  "Applying Berendsen-VanGunsteren thermostat..." << endl);
  double ekin;
  double ScaleTempFactor = configuration.Thermostats->TargetTemp/ActualTemp;
  for(ForwardIterator iter=begin;iter!=end;++iter){
    Vector &U = (*iter)->Trajectory.U.at(step);
    if ((*iter)->FixedIon == 0) { // even FixedIon moves, only not by other's forces
      U *= sqrt(1+(configuration.Deltat/configuration.Thermostats->TempFrequency)*(ScaleTempFactor-1));
      ekin += 0.5*(*iter)->getType()->mass * U.NormSquared();
    }
  }
  return ekin;
}
