/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * TranslateAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"
#include "Atom/atom.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <fstream>
#include <string>

#include "Actions/AtomAction/TranslateAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "TranslateAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr AtomTranslateAction::performCall() {
  Box &domain = World::getInstance().getDomain();
  std::vector<atom *> selectedAtoms = World::getInstance().getSelectedAtoms();

  // TODO: use AtomSet::translate
  for (std::vector<atom *>::iterator iter = selectedAtoms.begin(); iter != selectedAtoms.end(); ++iter) {
    *(*iter) += params.x.get();
    if (params.periodic.get())
      (*iter)->setPosition(domain.enforceBoundaryConditions((*iter)->getPosition()));
  }

  return ActionState::ptr(new AtomTranslateState(selectedAtoms, params));
}

ActionState::ptr AtomTranslateAction::performUndo(ActionState::ptr _state) {
  AtomTranslateState *state = assert_cast<AtomTranslateState*>(_state.get());
  Box &domain = World::getInstance().getDomain();

  for (std::vector<atom *>::iterator iter = state->selectedAtoms.begin(); iter != state->selectedAtoms.end(); ++iter) {
    *(*iter) -= state->params.x.get();
    if (state->params.periodic.get())
      (*iter)->setPosition(domain.enforceBoundaryConditions((*iter)->getPosition()));
  }

  return ActionState::ptr(_state);
}

ActionState::ptr AtomTranslateAction::performRedo(ActionState::ptr _state){
  AtomTranslateState *state = assert_cast<AtomTranslateState*>(_state.get());
  Box &domain = World::getInstance().getDomain();

  for (std::vector<atom *>::iterator iter = state->selectedAtoms.begin(); iter != state->selectedAtoms.end(); ++iter) {
    *(*iter) += state->params.x.get();
    if (state->params.periodic.get())
      (*iter)->setPosition(domain.enforceBoundaryConditions((*iter)->getPosition()));
  }

  return ActionState::ptr(_state);
}

bool AtomTranslateAction::canUndo() {
  return true;
}

bool AtomTranslateAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
