/*
 * MoleculeView.hpp
 *
 *  Created on: Mar 4, 2010
 *      Author: crueger
 */

#ifndef QTINFOBOX_HPP_
#define QTINFOBOX_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <string>
#include <QtGui/QTabWidget>
#include <QtGui/QTreeWidget>
#include <QTimer>
#include "CodePatterns/Observer/Observer.hpp"

class molecule;
class atom;

// Forwarding of the Tab-Pages
class QtAtomInfoPage;
class QtMoleculeInfoPage;

class QtInfoBox : public QTabWidget
{
  Q_OBJECT
public:
  QtInfoBox();
  virtual ~QtInfoBox();

  void showAtom(const atom *_atom);

public slots:
  void atomHover(const atom *_atom);
  void timerTimeout();

  void clearTabs();

private:
  const atom *curAtom;
  const atom *nextAtom;
  QtMoleculeInfoPage *page_mol;
  QtAtomInfoPage *page_atom;

  QTimer *timer;
};

/**
 * Widget to display the tab page for a single atom
 */
class QtAtomInfoPage : public QTreeWidget, public Observer {
  Q_OBJECT
public:
  QtAtomInfoPage(const atom *_atom, QWidget *parent);
  virtual ~QtAtomInfoPage();
  void update(Observable *subject);
  void subjectKilled(Observable *subject);

signals:
  void atomKilled();

private:
  const atom *atomRef;
  QTreeWidget *info;
};

/**
 * Widget to display the tab page for a single molecule
 */
class QtMoleculeInfoPage : public QTreeWidget,  public Observer {
  Q_OBJECT
public:
  QtMoleculeInfoPage(const molecule *_mol, QWidget *parent);
  virtual ~QtMoleculeInfoPage();

  void update(Observable *subject);
  void subjectKilled(Observable *subject);

  signals:
    void moleculeKilled();

private:
  const molecule *mol;
  QTreeWidget *info;
};
#endif /* QTINFOBOX_HPP_ */
