/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ActionMenuItem.cpp
 *
 *  Created on: Dec 11, 2009
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>

#include "Menu/TextMenu/ActionMenuItem.hpp"
#include "Actions/Action.hpp"
#include "Actions/ActionRegistry.hpp"

using namespace MoleCuilder;

ActionMenuItem::ActionMenuItem(char _trigger, const std::string &_description,TxMenu* const _menu,const std::string &_ActionName)
: MenuItem(_trigger,_description,_menu),
  ActionName(_ActionName)
{
}

ActionMenuItem::~ActionMenuItem()
{}

void ActionMenuItem::doTrigger() {
  Action* action = ActionRegistry::getInstance().getActionByName(ActionName);
  action->call();
}

bool ActionMenuItem::isActive() {
  Action* action = ActionRegistry::getInstance().getActionByName(ActionName);
  return action->isActive();
}
