/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * WorldStub.cpp
 *
 *  Created on: Dec 22, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "World.hpp"

#include "CodePatterns/Observer/Channels.hpp"
#include "CodePatterns/Observer/Notification.hpp"
#include "CodePatterns/Observer/ObservedContainer_impl.hpp"
#include "CodePatterns/Singleton_impl.hpp"

#include "IdPool_impl.hpp"

atom* World::_lastchangedatom = NULL;

World::World() :
    Observable("World"),
    atoms(this),
    selectedAtoms(this),
    atomIdPool(0, 20, 100),
    molecules(this),
    selectedMolecules(this),
    moleculeIdPool(0, 20,100)
{
  // observable stuff
  Channels *OurChannel = new Channels;
  NotificationChannels.insert( std::make_pair(this, OurChannel) );
  // add instance for each notification type
  OurChannel->addChannel(World::AtomInserted);
  OurChannel->addChannel(World::AtomRemoved);
}

World::~World()
{
  // observable stuff
  std::map<Observable *, Channels*>::iterator iter = NotificationChannels.find(this);
  delete iter->second;
  NotificationChannels.erase(iter);
}

CONSTRUCT_SINGLETON(World);
