/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AtomObserverStub.cpp
 *
 *  Created on: Dec 22, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Atom/AtomObserver.hpp"
#include "Atom/atom_observable.hpp"

#include "CodePatterns/Observer/Channels.hpp"
#include "CodePatterns/Observer/Notification.hpp"
#include "CodePatterns/Singleton_impl.hpp"

AtomObserver::AtomObserver() :
  Relay("AtomObserverStub")
{
  Channels *OurChannel = new Channels();
  NotificationChannels.insert( std::make_pair(this, OurChannel) );
  OurChannel->addChannel(AtomObservable::PositionChanged);
}

AtomObserver::~AtomObserver()
{
  // observable stuff
  std::map<Observable *, Channels*>::iterator iter = NotificationChannels.find(this);
  delete iter->second;
  NotificationChannels.erase(iter);
}

CONSTRUCT_SINGLETON(AtomObserver);
