/*
 * RandomNumberEngine_Encapsulation.hpp
 *
 *  Created on: Jan 01, 2011
 *      Author: heber
 */

#ifndef RANDOMNUMBERENGINE_ENCAPSULATION_HPP_
#define RANDOMNUMBERENGINE_ENCAPSULATION_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <typeinfo>

#include <boost/nondet_random.hpp>
#include <boost/random.hpp>
#include <boost/random/additive_combine.hpp>
#include <boost/random/discard_block.hpp>
#include <boost/random/inversive_congruential.hpp>
#include <boost/random/lagged_fibonacci.hpp>
#include <boost/random/linear_congruential.hpp>
#include <boost/random/linear_feedback_shift.hpp>
#include <boost/random/mersenne_twister.hpp>
#include <boost/random/random_number_generator.hpp>
#include <boost/random/ranlux.hpp>
#include <boost/random/shuffle_output.hpp>
#include <boost/random/subtract_with_carry.hpp>
#include <boost/random/xor_combine.hpp>

#include "CodePatterns/Clone.hpp"
#include "RandomNumberEngine.hpp"

class RandomNumberEngineFactory;

/** Template class that encapsulates the random number engines from
 *  random::boost.
 *
 *
 * We need one template parameters:
 * -# the engine - generates uniform random numbers
 */
template <class engine>
class RandomNumberEngine_Encapsulation :
  public RandomNumberEngine,
  public Clone<RandomNumberEngine>
{
    /**
     * Factory is friend such that it can access private cstor when filling its
     * table
     */
    friend class RandomNumberEngineFactory;

public:
  /** Set the engine's seed.
   *
   * @param _seed seed to set to
   */
  void seed(unsigned int _seed) {
    value_seed = _seed;
    engine_type.seed(value_seed);
  }

  /** Getter for the engine's seed.
   *
   * @return seed
   */
  unsigned int getseed() const {
    return value_seed;
  }

  /** Getter for smallest value the engine produces.
   *
   * @return smallest value
   */
  double min() const {
    return engine_type.min();
  }

  /** Getter for largest value the engine produces.
   *
   * @return largest value
   */
  double max() const {
    return engine_type.max();
  }

  /** Getter for the type name of the internal engine.
   *
   */
  std::string name() {
    return typeid(engine_type).name();
  }

  /** Getter for the engine instance.
   *
   * @return reference to instance
   */
  engine& getEngine() {
    return engine_type;
  }

  /** Clones the current instance.
   *
   * Implementation of Clone pattern.
   *
   * @return interface reference to cloned instance
   */
  RandomNumberEngine* clone() const {
    RandomNumberEngine* MyClone = NULL;
    MyClone = new RandomNumberEngine_Encapsulation<engine>();
    MyClone->seed(getseed());
    return MyClone;
  }

protected:
  /** Constructor that instantiates a specific random number generator and
   * distribution.
   * @param _engine_type instance of the desired engine
   */
  RandomNumberEngine_Encapsulation() :
    value_seed(1)
  {}

  /** Destructor of the class.
   *
   */
  virtual ~RandomNumberEngine_Encapsulation() {}
private:
  engine engine_type;
  unsigned int value_seed;
};

#endif /* RANDOMNUMBERENGINE_ENCAPSULATION_HPP_ */
