/*
 * RandomNumberEngine.hpp
 *
 *  Created on: Jan 01, 2011
 *      Author: heber
 */

#ifndef RANDOMNUMBERENGINE_HPP_
#define RANDOMNUMBERENGINE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

class RandomNumberEngineFactoryTest;
class RandomNumberGenerator;

/** Abstract base class for a random number engine.
 *
 *  This class represents the interface to the random number engine.
 *  Hence, they all can be accessed the same way.
 *
 * It is also the base class that is needed for RandomNumberGeneratorFactory.
 */
class RandomNumberEngine
{
  /**
   * test has to access cstor/dstor.
   */
  friend class RandomNumberEngineFactoryTest;

  /**
   * RandomNumberGenerator(_Encapsulation) needs access to dstor.
   */
  friend class RandomNumberGenerator;

public:
  /** Set the generator's seed.
   *
   * @param _seed seed to set to
   */
  virtual void seed(unsigned int _seed)=0;

  /** Getter for smallest value the engine produces.
   *
   * @return smallest value
   */
  virtual double min() const=0;

  /** Getter for largest value the engine produces.
   *
   * @return largest value
   */
  virtual double max() const=0;

  /** Getter for the type name of the internal engine.
   *
   */
  virtual std::string name()=0;

  /** Destructor of class RandomNumberEngine.
   *
   * @note must be public such that instances from factory can be destroyed.
   *
   */
  virtual ~RandomNumberEngine() {};
protected:
  /** Constructor of class RandomNumberEngine.
   *
   * @note is protected such that instances can only be created by the factory.
   */
  RandomNumberEngine() {};

  /** Getter for the generator's seed.
   *
   * @note is only used internally for unit test.
   *
   * @return _seed seed to set to
   */
  virtual unsigned int getseed() const = 0;
};

#endif /* RANDOMNUMBERENGINE_HPP_ */
