/*
 * RandomNumberDistribution_Encapsulation.hpp
 *
 *  Created on: Jan 01, 2011
 *      Author: heber
 */

#ifndef RANDOMNUMBERDISTRIBUTION_ENCAPSULATION_HPP_
#define RANDOMNUMBERDISTRIBUTION_ENCAPSULATION_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/Assert.hpp"

#include <typeinfo>

#include <boost/nondet_random.hpp>
#include <boost/random.hpp>
#include <boost/random/bernoulli_distribution.hpp>
#include <boost/random/binomial_distribution.hpp>
#include <boost/random/cauchy_distribution.hpp>
#include <boost/random/exponential_distribution.hpp>
#include <boost/random/gamma_distribution.hpp>
#include <boost/random/geometric_distribution.hpp>
#include <boost/random/linear_congruential.hpp>
#include <boost/random/lognormal_distribution.hpp>
#include <boost/random/normal_distribution.hpp>
#include <boost/random/poisson_distribution.hpp>
#include <boost/random/triangle_distribution.hpp>
#include <boost/random/uniform_01.hpp>
#include <boost/random/uniform_int.hpp>
#include <boost/random/uniform_on_sphere.hpp>
#include <boost/random/uniform_real.hpp>
#include <boost/random/uniform_smallint.hpp>

#include "CodePatterns/Clone.hpp"
#include "RandomNumberDistribution.hpp"

class RandomNumberDistributionFactory;

/** Template class that encapsulates the random number distributions from
 *  random::boost.
 *
 *
 * We need one template parameters:
 * -# the distribution - generates uniform random numbers
 */
template <class distribution>
class RandomNumberDistribution_Encapsulation :
  public RandomNumberDistribution,
  public Clone<RandomNumberDistribution>
{
    /**
     * Factory is friend such that it can access private cstor when filling its
     * table
     */
    friend class RandomNumberDistributionFactory;

public:

  /** Getter for smallest value the engine produces.
   *
   * @return smallest value
   */
  double min() const {
    ASSERT(0, "min() not implemented for "+name());
    return -1.;
  }

  /** Getter for largest value the engine produces.
   *
   * @return largest value
   */
  double max() const {
    ASSERT(0, "max() not implemented for "+name());
    return -1.;
  }

  /** Getter for bernoulli_distribution's probability p.
   *
   * @return p
   */
  double p() const {
    ASSERT(0, "p() not implemented for "+name());
    return -1.;
  }

  /** Getter for binomial_distribution's parameter t.
   *
   * @return t
   */
  double t() const {
    ASSERT(0, "t() not implemented for "+name());
    return -1.;
  }

  /** Getter for cauchy_distribution parameter median.
   *
   * @return median
   */
  double median() const {
    ASSERT(0, "median() not implemented for "+name());
    return -1.;
  }

  /** Getter for cauchy_distribution parameter sigma.
   *
   * @return sigma
   */
  double sigma() const {
    ASSERT(0, "sigma() not implemented for "+name());
    return -1.;
  }

  /** Getter for gamma_distribution parameter alpha.
   *
   * @return alpha
   */
  double alpha() const {
    ASSERT(0, "alpha() not implemented for "+name());
    return -1.;
  }

  /** Getter for poisson_distribution's parameter mean.
   *
   * @return mean
   */
  double mean() const {
    ASSERT(0, "mean() not implemented for "+name());
    return -1.;
  }

  /** Getter for triangle_distribution parameter a.
   *
   * @return a
   */
  double a() const {
    ASSERT(0, "a() not implemented for "+name());
    return -1.;
  }

  /** Getter for triangle_distribution parameter b.
   *
   * @return b
   */
  double b() const {
    ASSERT(0, "b() not implemented for "+name());
    return -1.;
  }

  /** Getter for triangle_distribution parameter c.
   *
   * @return c
   */
  double c() const {
    ASSERT(0, "c() not implemented for "+name());
    return -1.;
  }

  /** Getter for exponential_distribution parameter lambda.
   *
   * @return lambda
   */
  double lambda() const {
    ASSERT(0, "lambda() not implemented for "+name());
    return -1.;
  }

  /** Getter for the type name of the internal distribution.
   *
   */
  std::string name() {
    return typeid(distribution_type).name();
  }

  /** Getter for the distribution instance.
   *
   * @return reference to instance
   */
  distribution& getDistribution() {
    return distribution_type;
  }

  /** Clones the current instance.
   *
   * Implementation of Clone pattern.
   *
   * @return interface reference to cloned instance
   */
  RandomNumberDistribution* clone() const {
    RandomNumberDistribution* MyClone = NULL;
    MyClone = new RandomNumberDistribution_Encapsulation<distribution>();
    return MyClone;
  }

protected:
  /** Constructor that instantiates a specific random number generator and
   * distribution.
   * @param _distribution_type instance of the desired distribution
   */
  RandomNumberDistribution_Encapsulation()
  {}

  /** Destructor of the class.
   *
   */
  virtual ~RandomNumberDistribution_Encapsulation() {}
private:
  distribution distribution_type;
};

// the following definitions prevents the compiler from instantiating the above
// template member functions for the desired cases.

/* ===============  min() ======================= */

template <>
double RandomNumberDistribution_Encapsulation< boost::uniform_smallint<> >::min() const;
template <>
double RandomNumberDistribution_Encapsulation< boost::uniform_int<> >::min() const;
template <>
double RandomNumberDistribution_Encapsulation< boost::uniform_01<> >::min() const;
template <>
double RandomNumberDistribution_Encapsulation< boost::uniform_real<> >::min() const;


/* ===============  max() ======================= */

template <>
double RandomNumberDistribution_Encapsulation< boost::uniform_smallint<> >::max() const;
template <>
double RandomNumberDistribution_Encapsulation< boost::uniform_int<> >::max() const;
template <>
double RandomNumberDistribution_Encapsulation< boost::uniform_01<> >::max() const;
template <>
double RandomNumberDistribution_Encapsulation< boost::uniform_real<> >::max() const;


/* ===============  p() ======================= */

template <>
double RandomNumberDistribution_Encapsulation< boost::bernoulli_distribution<> >::p() const;
template <>
double RandomNumberDistribution_Encapsulation< boost::binomial_distribution<> >::p() const;
template <>
double RandomNumberDistribution_Encapsulation< boost::geometric_distribution<> >::p() const;


/* ===============  t() ======================= */

template <>
double RandomNumberDistribution_Encapsulation< boost::binomial_distribution<> >::t() const;


/* ===============  median() ======================= */

template <>
double RandomNumberDistribution_Encapsulation< boost::cauchy_distribution<> >::median() const;


/* ===============  sigma() ======================= */

template <>
double RandomNumberDistribution_Encapsulation< boost::cauchy_distribution<> >::sigma() const;
template <>
double RandomNumberDistribution_Encapsulation< boost::normal_distribution<> >::sigma() const;
template <>
double RandomNumberDistribution_Encapsulation< boost::lognormal_distribution<> >::sigma() const;


/* ===============  alpha() ======================= */

template <>
double RandomNumberDistribution_Encapsulation< boost::gamma_distribution<> >::alpha() const;


/* ===============  mean() ======================= */

template <>
double RandomNumberDistribution_Encapsulation< boost::poisson_distribution<> >::mean() const;
template <>
double RandomNumberDistribution_Encapsulation< boost::normal_distribution<> >::mean() const;
template <>
double RandomNumberDistribution_Encapsulation< boost::lognormal_distribution<> >::mean() const;


/* ===============  a() ======================= */

template <>
double RandomNumberDistribution_Encapsulation< boost::triangle_distribution<> >::a() const;


/* ===============  b() ======================= */

template <>
double RandomNumberDistribution_Encapsulation< boost::triangle_distribution<> >::b() const;


/* ===============  c() ======================= */

template <>
double RandomNumberDistribution_Encapsulation< boost::triangle_distribution<> >::c() const;


/* ===============  lambda() ======================= */

template <>
double RandomNumberDistribution_Encapsulation< boost::exponential_distribution<> >::lambda() const;



#endif /* RANDOMNUMBERDISTRIBUTION_ENCAPSULATION_HPP_ */
