/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * \file RandomNumberDistribution_Encapsulation_impl.hpp
 *
 * Herein we place specializations of specific functions for specific distributions.
 *
 *  Created on: Jan 5, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "RandomNumberDistribution_Encapsulation.hpp"


/* ===============  min() ======================= */

template <>
double RandomNumberDistribution_Encapsulation< boost::uniform_smallint<> >::min() const
{
	return distribution_type.min();
}

template <>
double RandomNumberDistribution_Encapsulation< boost::uniform_int<> >::min() const
{
	return distribution_type.min();
}

template <>
double RandomNumberDistribution_Encapsulation< boost::uniform_01<> >::min() const
{
	return distribution_type.min();
}

template <>
double RandomNumberDistribution_Encapsulation< boost::uniform_real<> >::min() const
{
	return distribution_type.min();
}



/* ===============  max() ======================= */

template <>
double RandomNumberDistribution_Encapsulation< boost::uniform_smallint<> >::max() const
{
  return distribution_type.max();
}

template <>
double RandomNumberDistribution_Encapsulation< boost::uniform_int<> >::max() const
{
  return distribution_type.max();
}

template <>
double RandomNumberDistribution_Encapsulation< boost::uniform_01<> >::max() const
{
  return distribution_type.max();
}

template <>
double RandomNumberDistribution_Encapsulation< boost::uniform_real<> >::max() const
{
  return distribution_type.max();
}


/* ===============  p() ======================= */

template <>
double RandomNumberDistribution_Encapsulation< boost::bernoulli_distribution<> >::p() const
{
  return distribution_type.p();
}

template <>
double RandomNumberDistribution_Encapsulation< boost::binomial_distribution<> >::p() const
{
  return distribution_type.p();
}

template <>
double RandomNumberDistribution_Encapsulation< boost::geometric_distribution<> >::p() const
{
  return distribution_type.p();
}


/* ===============  t() ======================= */

template <>
double RandomNumberDistribution_Encapsulation< boost::binomial_distribution<> >::t() const
{
  return distribution_type.t();
}

/* ===============  median() ======================= */

template <>
double RandomNumberDistribution_Encapsulation< boost::cauchy_distribution<> >::median() const
{
  return distribution_type.median();
}

/* ===============  sigma() ======================= */

template <>
double RandomNumberDistribution_Encapsulation< boost::cauchy_distribution<> >::sigma() const
{
  return distribution_type.sigma();
}

template <>
double RandomNumberDistribution_Encapsulation< boost::normal_distribution<> >::sigma() const
{
  return distribution_type.sigma();
}

template <>
double RandomNumberDistribution_Encapsulation< boost::lognormal_distribution<> >::sigma() const
{
  return distribution_type.sigma();
}

/* ===============  alpha() ======================= */

template <>
double RandomNumberDistribution_Encapsulation< boost::gamma_distribution<> >::alpha() const
{
  return distribution_type.alpha();
}


/* ===============  mean() ======================= */

template <>
double RandomNumberDistribution_Encapsulation< boost::poisson_distribution<> >::mean() const
{
  return distribution_type.mean();
}

template <>
double RandomNumberDistribution_Encapsulation< boost::normal_distribution<> >::mean() const
{
  return distribution_type.mean();
}

template <>
double RandomNumberDistribution_Encapsulation< boost::lognormal_distribution<> >::mean() const
{
  return distribution_type.mean();
}

/* ===============  a() ======================= */

template <>
double RandomNumberDistribution_Encapsulation< boost::triangle_distribution<> >::a() const
{
  return distribution_type.a();
}


/* ===============  b() ======================= */

template <>
double RandomNumberDistribution_Encapsulation< boost::triangle_distribution<> >::b() const
{
  return distribution_type.b();
}


/* ===============  c() ======================= */

template <>
double RandomNumberDistribution_Encapsulation< boost::triangle_distribution<> >::c() const
{
  return distribution_type.c();
}


/* ===============  lambda() ======================= */

template <>
double RandomNumberDistribution_Encapsulation< boost::exponential_distribution<> >::lambda() const
{
  return distribution_type.lambda();
}


