/*
 * RandomNumberDistribution.hpp
 *
 *  Created on: Jan 01, 2011
 *      Author: heber
 */

#ifndef RANDOMNUMBERDISTRIBUTION_HPP_
#define RANDOMNUMBERDISTRIBUTION_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

class RandomNumberDistributionFactoryTest;
class RandomNumberGenerator;

/** Abstract base class for a random number distribution.
 *
 *  This class represents the interface to the random number distribution.
 *  Hence, they all can be accessed the same way.
 *
 * It is also the base class that is needed for RandomNumberGeneratorFactory.
 */
class RandomNumberDistribution
{
  /**
   * test has to access cstor/dstor.
   */
  friend class RandomNumberDistributionFactoryTest;

  /**
   * RandomNumberGenerator(_Encapsulation) needs access to dstor.
   */
  friend class RandomNumberGenerator;

public:
  /** Getter for smallest value the engine produces.
   *
   * @return smallest value
   */
  virtual double min() const=0;

  /** Getter for largest value the engine produces.
   *
   * @return largest value
   */
  virtual double max() const=0;


  /** Getter for bernoulli_distribution probability p.
   *
   * @return p
   */
  virtual double p() const=0;

  /** Getter for the type name of the internal distribution.
   *
   */
  virtual std::string name()=0;

  /** Destructor of class RandomNumberDistribution.
   *
   * @note must be public such that instances from factory can be destroyed.
   *
   */
  virtual ~RandomNumberDistribution() {};
protected:

  /** Constructor of class RandomNumberDistribution.
   *
   * @note is protected such that instances can only be created by the factory.
   */
  RandomNumberDistribution() {};
};

#endif /* RANDOMNUMBERDISTRIBUTION_HPP_ */
