/*
 * AtomicInfo.hpp
 *
 *  Created on: Aug 10, 2010
 *      Author: heber
 */

#ifndef ATOMICINFO_HPP_
#define ATOMICINFO_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "LinearAlgebra/Vector.hpp"
#include "types.hpp"

#include <vector>

#include "Bond/BondInfo.hpp"

class atom;
class element;
class molecule;

/** This is for storing and transfering the information contained within an atom.
 * This is needed for Undo/Redo operations of AtomActions.
 */
class AtomicInfo {
public:
  AtomicInfo();
  AtomicInfo(const atom &_atom);
  AtomicInfo(const AtomicInfo &_atominfo);
  ~AtomicInfo();

  bool setAtom(atom &_atom) const;
  atomId_t getId() const;

  AtomicInfo& operator=(const AtomicInfo&);

private:
  Vector Position;
  const element * Type;
  double charge;
  Vector Velocity;
  Vector Force;
  atomId_t FatherId;
  moleculeId_t MolId;
  atomId_t Id;
  int Nr;
  std::vector<BondInfo> bonds;
};


#endif /* ATOMICINFO_HPP_ */
