/*
 * GLMoleculeObject_shape.hpp
 *
 *  Created on: Aug 3, 2012
 *      Author: ankele
 */

#ifndef GLMOLECULEOBJECT_SHAPE_HPP_
#define GLMOLECULEOBJECT_SHAPE_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <QtCore/qobject.h>

#include <Qt3D/qglpainter.h>
#include <Qt3D/qglabstractscene.h>

#include "GLMoleculeObject.hpp"

#include "Shapes/Shape.hpp"

/** This class represents a triangulated Shape.
 *
 */
class GLMoleculeObject_shape : public GLMoleculeObject
{
   Q_OBJECT
public:
   explicit GLMoleculeObject_shape(Shape &shape, QObject *parent=0);
   virtual ~GLMoleculeObject_shape();

   virtual void draw(QGLPainter *painter, const QVector4D &cameraPlane);
   void enable(bool enabled);
   Shape *getShape(){ return &m_shape;  }

private:

   Shape m_shape;
   bool m_enabled;
};

#endif /* GLMOLECULEOBJECT_SHAPE_HPP_ */
