/*
 * SamplingGridUnitTest.hpp
 *
 *  Created on: Jul 29, 2012
 *      Author: heber
 */

#ifndef SAMPLINGGRIDUNITTEST_HPP_
#define SAMPLINGGRIDUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <cppunit/extensions/HelperMacros.h>

#include "Fragmentation/Summation/SetValues/SamplingGrid.hpp"

/********************************************** Test classes **************************************/

class SamplingGridTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( SamplingGridTest) ;
    CPPUNIT_TEST ( equivalentGrids_Test );
    CPPUNIT_TEST ( compatibleGrids_Test );
    CPPUNIT_TEST ( operatorPlusEqual_Test );
    CPPUNIT_TEST ( operatorMinusEqual_Test );
    CPPUNIT_TEST ( isCongruent_Test );
    CPPUNIT_TEST ( integral_Test );
    CPPUNIT_TEST ( getVolume_Test );
    CPPUNIT_TEST ( getWindowSize_Test );
    CPPUNIT_TEST ( extendWindow_Test );
    CPPUNIT_TEST ( extendWindow_asymmetric_Test );
    CPPUNIT_TEST ( addOntoWindow_Test );
    CPPUNIT_TEST ( addOntoWindow_asymmetric_Test );
    CPPUNIT_TEST ( equality_Test );
    CPPUNIT_TEST ( serializeTest );
    CPPUNIT_TEST ( downsampleTest );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();
      void equivalentGrids_Test();
      void compatibleGrids_Test();
      void isCongruent_Test();
      void integral_Test();
      void getVolume_Test();
      void getWindowSize_Test();
      void extendWindow_Test();
      void extendWindow_asymmetric_Test();
      void addOntoWindow_Test();
      void addOntoWindow_asymmetric_Test();
      void operatorPlusEqual_Test();
      void operatorMinusEqual_Test();
      void equality_Test();
      void serializeTest();
      void downsampleTest();

private:
      SamplingGrid *grid;
      SamplingGrid::sampledvalues_t values;
};

#endif /* SAMPLINGGRIDUNITTEST_HPP_ */
