/*
 * OrthogonalSumUpPerLevel.hpp
 *
 *  Created on: Aug 27, 2012
 *      Author: heber
 */

#ifndef ORTHOGONALSUMUPPERLEVEL_HPP_
#define ORTHOGONALSUMUPPERLEVEL_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <map>
#include <vector>

#include "Fragmentation/Converter/DataConverter.hpp"
#include "Fragmentation/Summation/AllLevelOrthogonalSummator.hpp"
#include "Fragmentation/Summation/IndexSetContainer.hpp"

#include "Jobs/MPQCData.hpp"

#include <boost/mpl/for_each.hpp>

template <typename TypeMap, typename TypeVector>
std::vector<TypeMap> OrthogonalSumUpPerLevel(
    const std::vector<MPQCData> &fragmentData,
    const std::vector<JobId_t> &jobids,
    std::map< JobId_t, size_t > &MatrixNrLookup,
    const IndexSetContainer::ptr &container,
    SubsetMap::ptr &subsetmap
    )
{
  // place data into boost::fusion::map instance
  std::vector<TypeMap> MPQCData_fused;
  convertDataTo<MPQCData, TypeMap>(fragmentData, MPQCData_fused);
  // instantiate summator
  std::vector<TypeMap> Result_fused(subsetmap->getMaximumSubsetLevel());
  AllLevelOrthogonalSummator<TypeMap> Summer(
              subsetmap,
              MPQCData_fused,
              jobids,
              container->getContainer(),
              MatrixNrLookup,
              Result_fused);
  // sum up for each type key in TypeVector
  boost::mpl::for_each<TypeVector>(boost::ref(Summer));
  return Result_fused;
}


#endif /* ORTHOGONALSUMUPPERLEVEL_HPP_ */
