/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * LinkedCellUnitTest.cpp
 *
 *  Created on: Nov 14, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "Atom/TesselPoint.hpp"
#include "CodePatterns/Assert.hpp"
#include "LinkedCell/LinkedCell.hpp"

#include "LinkedCellUnitTest.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( LinkedCelltest );


void LinkedCelltest::setUp()
{
  // failing asserts should be thrown
  ASSERT_DO(Assert::Throw);

  // this must not compile as default cstor is private
  //cell = new LinkedCell();

  indices[0] = indices[1] = indices[2] = 0;
  cell = new LinkedCell::LinkedCell(indices);
  CPPUNIT_ASSERT(cell != NULL);
}


void LinkedCelltest::tearDown()
{
  delete cell;
}

/** UnitTest for list capabilities.
 */
void LinkedCelltest::ListTest()
{
  TesselPoint *Walker = new TesselPoint;

  // add a point
  cell->push_back(Walker);
  CPPUNIT_ASSERT_EQUAL((size_t)1, cell->size());

  // remove point
  LinkedCell::LinkedCell::iterator iter = cell->begin();
  const TesselPoint *OtherWalker = *iter;
  CPPUNIT_ASSERT(Walker == OtherWalker);
  cell->erase(iter);
  CPPUNIT_ASSERT_EQUAL((size_t)0, cell->size());

  delete Walker;
}

std::ostream & operator<<(std::ostream &ost, const LinkedCell::tripleIndex& indices)
{
  ost << indices[0] << "," << indices[1] << "," << indices[2];
  return ost;
}

/** UnitTest for LinkedCell::addPoint() and LinkedCell::deletePoint()
 */
void LinkedCelltest::adddeletePointTest()
{
  TesselPoint *Walker = new TesselPoint;

  // add a point
  cell->addPoint(Walker);
  CPPUNIT_ASSERT_EQUAL((size_t)1, cell->size());
  CPPUNIT_ASSERT(Walker == *(cell->begin()));

  // remove point
  cell->deletePoint(Walker);
  CPPUNIT_ASSERT_EQUAL((size_t)0, cell->size());

  delete Walker;

}

/** UnitTest for LinkedCell::getIndices().
 */
void LinkedCelltest::IndexTest()
{
  // check reference returned
  const LinkedCell::tripleIndex &returnedindices = cell->getIndices();
  CPPUNIT_ASSERT_EQUAL(indices, returnedindices);

  // check each index
  for(size_t i=0;i<3;++i)
    CPPUNIT_ASSERT_EQUAL( indices[i], cell->getIndex(i) );
}
