/*
 * Calculation.hpp
 *
 *  Created on: Feb 19, 2010
 *      Author: crueger
 */

#ifndef CALCULATION_HPP_
#define CALCULATION_HPP_

#include "Actions/Process.hpp"

template<typename T>
class Calculation : public Process
{
public:
  Calculation(int _maxSteps, std::string _name, bool _doRegister=true);
  virtual ~Calculation();

  virtual void call();
  virtual void undo();
  virtual bool canUndo();

  virtual T operator()();
  virtual bool hasResult();
  virtual T getResult();
  virtual void reset();

protected:
  T* result;
  virtual T* doCalc()=0;
private:
  bool done;
};

#endif /* CALCULATION_HPP_ */
