/*
 * AtomsCalculation_impl.hpp
 *
 *  Created on: Feb 19, 2010
 *      Author: crueger
 */

#ifndef ATOMSCALCULATION_IMPL_HPP_
#define ATOMSCALCULATION_IMPL_HPP_

#include "Actions/AtomsCalculation.hpp"
#include "Actions/Calculation_impl.hpp"

#include <iostream>

using namespace std;

template<typename T>
AtomsCalculation<T>::AtomsCalculation(boost::function<T(atom*)> _op,std::string name,AtomDescriptor _descr) :
  Calculation<std::vector<T> >(0,name,false),
  op(_op),
  descr(_descr)
{}

template<typename T>
AtomsCalculation<T>::~AtomsCalculation(){
}

template<typename T>
std::vector<T>* AtomsCalculation<T>::doCalc(){
  World* world = World::get();
  int steps = world->numAtoms();
  int count = 0;
  std::vector<T> *res = new std::vector<T>();
  res->reserve(steps);
  Process::setMaxSteps(steps);
  Process::start();
  World::AtomIterator iter;
  for(iter=world->getAtomIter(descr);iter!=world->atomEnd();++iter){
    Process::setCurrStep(iter.getCount());
    res->push_back(op(*iter));
  }
  Process::stop();
  return res;
}


#endif /* ATOMSCALCULATION_IMPL_HPP_ */
