dnl
dnl AM_PATH_JOBMARKET(MINIMUM-VERSION, [HAVE_DEBUG=no,yes,full], [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl

AC_DEFUN([AM_PATH_JOBMARKET],
[
AC_REQUIRE([AM_PATH_CODEPATTERNS])

AC_ARG_WITH(jobmarket,[  --with-jobmarket=PFX   Prefix where JobMarket is installed (optional)],
            jobmarket_prefix="$withval", jobmarket_prefix="")
AC_ARG_WITH(jobmarket_include,[  --with-jobmarket_include=INCLUDE   Where JobMarket' includes are installed (optional)],
            jobmarket_include_prefix="$withval", jobmarket_include_prefix="")
AC_ARG_WITH(cp_cv_jobmarket_libs,[  --with-cp_cv_jobmarket_libs=LIBPATH   Where JobMarket' libs are installed (optional)],
            cp_cv_jobmarket_libs_prefix="$withval", cp_cv_jobmarket_libs_prefix="")

  jobmarket_version_min=$1
  jobmarket_debug=$2

  JobMarket_CFLAGS=""
  JobMarket_LIBS=""
  JobMarket_Controller_LIBS=""
  JobMarket_PoolWorker_LIBS=""
  JobMarket_Server_LIBS=""
  JobMarket_LDFLAGS=""

 
  jobmarket_pkgconfig=""
  # try to set PKG_CONFIG_PATH
  if test x$jobmarket_prefix != xno; then
    if test -z $PKG_CONFIG_PATH; then
      export PKG_CONFIG_PATH="$jobmarket_prefix/lib/pkgconfig/"
    else
      export PKG_CONFIG_PATH="$jobmarket_prefix/lib/pkgconfig/:$PKG_CONFIG_PATH"
    fi
  fi
  # 1. test whether pkg-config works
  JobMarket_CONFIG="no"
  #AC_MSG_NOTICE([PKG_CONFIG_PATH is $PKG_CONFIG_PATH.])
  jobmarket_libname="JobMarket"
  if test x$jobmarket_debug != xno; then
    PKG_CHECK_MODULES([JobMarket_debug], [JobMarket >= $jobmarket_version_min], [
      jobmarket_pkgconfig=yes
      JobMarket_CONFIG="pkg-config ${jobmarket_libname}-debug"
    ], [
      jobmarket_pkgconfig=no
    ])
    PKG_CHECK_MODULES([JobMarketController_debug], [JobMarketController >= $jobmarket_version_min], [
      jobmarketcontroller_pkgconfig=yes
      JobMarketController_CONFIG="pkg-config ${jobmarket_libname}Controller-debug"
    ], [
      jobmarketcontroller_pkgconfig=no
    ])
    PKG_CHECK_MODULES([JobMarketPoolWorker_debug], [JobMarketPoolWorker >= $jobmarket_version_min], [
      jobmarketpoolworker_pkgconfig=yes
      JobMarketPoolWorker_CONFIG="pkg-config ${jobmarket_libname}PoolWorker-debug"
    ], [
      jobmarketpoolworker_pkgconfig=no
    ])
    PKG_CHECK_MODULES([JobMarketServer_debug], [JobMarketServer >= $jobmarket_version_min], [
      jobmarketserver_pkgconfig=yes
      JobMarketServer_CONFIG="pkg-config ${jobmarket_libname}Server-debug"
    ], [
      jobmarketserver_pkgconfig=no
    ])
  else
    PKG_CHECK_MODULES([JobMarket], [JobMarket >= $jobmarket_version_min], [
      jobmarket_pkgconfig=yes
      JobMarket_CONFIG="pkg-config $jobmarket_libname"
    ], [
      jobmarket_pkgconfig=no
    ])
    PKG_CHECK_MODULES([JobMarketController], [JobMarketController >= $jobmarket_version_min], [
      jobmarketcontroller_pkgconfig=yes
      JobMarketController_CONFIG="pkg-config ${jobmarket_libname}Controller"
    ], [
      jobmarketcontroller_pkgconfig=no
    ])
    PKG_CHECK_MODULES([JobMarketPoolWorker], [JobMarketPoolWorker >= $jobmarket_version_min], [
      jobmarketpoolworker_pkgconfig=yes
      JobMarketPoolWorker_CONFIG="pkg-config ${jobmarket_libname}PoolWorker"
    ], [
      jobmarketpoolworker_pkgconfig=no
    ])
    PKG_CHECK_MODULES([JobMarketServer], [JobMarketServer >= $jobmarket_version_min], [
      jobmarketserver_pkgconfig=yes
      JobMarketServer_CONFIG="pkg-config ${jobmarket_libname}Server"
    ], [
      jobmarketserver_pkgconfig=no
    ])
  fi


  if test x$jobmarket_pkgconfig != xno; then
    JobMarket_CFLAGS=`$JobMarket_CONFIG --cflags`
    JobMarket_LIBS=`$JobMarket_CONFIG --libs`
  fi
  if test x$jobmarketcontroller_pkgconfig != xno; then
    JobMarket_Controller_LIBS=`$JobMarketController_CONFIG --libs`
  fi
  if test x$jobmarketpoolworker_pkgconfig != xno; then
    JobMarket_PoolWorker_LIBS=`$JobMarketPoolWorker_CONFIG --libs`
  fi
  if test x$jobmarketserver_pkgconfig != xno; then
    JobMarket_Server_LIBS=`$JobMarketServer_CONFIG --libs`
  fi

  # else set by hand (or rather by --with..)
  if test x$jobmarket_include_prefix != x ; then
    if test -e $jobmarket_include_prefix/include; then
      JobMarket_CFLAGS="$jobmarket_include_prefix/include"
      #AC_MSG_NOTICE([jobmarket include found and used.])
    else
      AC_MSG_WARN([jobmarket include not found at $jobmarket_include_prefix/include.])
    fi
  fi
  if test x$cp_cv_jobmarket_libs_prefix != x ; then
    if test -e "$cp_cv_jobmarket_libs_prefix/lib/lib$jobmarket_libname.so"; then
      JobMarket_LDFLAGS="-L$cp_cv_jobmarket_libs_prefix/lib"
      JobMarket_LIBS="-l$jobmarket_libname"
      JobMarket_Controller_LIBS="-l${jobmarket_libname}Controller"
      JobMarket_PoolWorker_LIBS="-l${jobmarket_libname}PoolWorker"
      JobMarket_Server_LIBS="-l${jobmarket_libname}Server"
      #AC_MSG_NOTICE([jobmarket libs found and used.])
    else
      AC_MSG_WARN([jobmarket libs not found at $cp_cv_jobmarket_libs_prefix.])
    fi
  fi

  jobmarket="no"
  if test "x$JobMarket_CFLAGS" != "x"; then
    if test "x$JobMarket_LIBS" != "x"; then
      jobmarket="yes"
    fi
  fi


  if test x$jobmarket_pkgconfig != xyes; then
    # check version of lib
    no_jobmarket=""
    jobmarket_version=no
    if test x$jobmarket = xyes; then
      AC_MSG_CHECKING(for $jobmarket_libname - version >= $jobmarket_version_min)
      if test "x$JobMarket_CONFIG" != xno; then
        jobmarket_version=`$JobMarket_CONFIG --version`
      else
        jobmarket_version=""
      fi
  
      jobmarket_major_version=`echo $jobmarket_version | \
             sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
      jobmarket_minor_version=`echo $jobmarket_version | \
             sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
      jobmarket_micro_version=`echo $jobmarket_version | \
             sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
  
      #AC_MSG_NOTICE([Version found is: $jobmarket_major_version.$jobmarket_minor_version.$jobmarket_micro_version])
      #AC_MSG_NOTICE([Version required is: $jobmarket_version_min])
  
      jobmarket_major_min=`echo $jobmarket_version_min | \
             sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
      if test "x${jobmarket_major_min}" = "x" ; then
         jobmarket_major_min=0
      fi
      
      jobmarket_minor_min=`echo $jobmarket_version_min | \
             sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
      if test "x${jobmarket_minor_min}" = "x" ; then
         jobmarket_minor_min=0
      fi
  
      jobmarket_micro_min=`echo $jobmarket_version_min | \
             sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
      if test "x${jobmarket_micro_min}" = "x" ; then
         jobmarket_micro_min=0
      fi
  
      if test $jobmarket_major_version -lt $jobmarket_major_min; then
        jobmarket_version_proper=0
      fi
      if test $jobmarket_major_version -gt $jobmarket_major_min; then
        jobmarket_version_proper=1
      else
        if test $jobmarket_minor_version -lt $jobmarket_minor_min; then
          jobmarket_version_proper=0
        fi
        if test $jobmarket_minor_version -gt $jobmarket_minor_min; then
          jobmarket_version_proper=1
        else
          if test $jobmarket_micro_version -ge $jobmarket_micro_min; then
            jobmarket_version_proper=1
          else 
            jobmarket_version_proper=0
          fi
        fi
      fi
      #AC_MSG_NOTICE([$jobmarket_version_proper])
      
      if test $jobmarket_version_proper = 1 ; then
        jobmarket_version=yes
        AC_MSG_RESULT([$jobmarket_major_version.$jobmarket_minor_version.$jobmarket_micro_version])
      else
        AC_MSG_RESULT(no)
        jobmarket_version=no
      fi
    fi
  else
    # with pkg-config version is checked
    jobmarket_version=yes
  fi
  # check presence of lib
  SAVE_CPPFLAGS="$CPPFLAGS"
  SAVE_LIBS="$LIBS"
  CPPFLAGS="$JobMarket_CFLAGS  ${CodePatterns_CFLAGS}"
  LIBS="$JobMarket_LIBS $CodePatterns_LDFLAGS $CodePatterns_LIBS"
  if test x$jobmarket_version = xyes; then
    AC_CACHE_CHECK(for $jobmarket_libname lib, cp_cv_jobmarket_lib, [
      AC_LANG_PUSH([C++])
      AC_LINK_IFELSE(
        [
          AC_LANG_PROGRAM([

#include "CodePatterns/MemDebug.hpp"
#include "JobMarket/JobId.hpp"

struct Test {
  Test(size_t _id) :
      id(_id)
  {}
  
  size_t getId() const {
    return id.getId();
  }
  
private:
  JobId id;
} test(1);

], [
test.getId();
])
        ],[
          cp_cv_jobmarket_lib="yes"
        ], [
          cp_cv_jobmarket_lib="no"
        ]
      )
      AC_LANG_POP([C++])
    ])
  fi
  CPPFLAGS="$SAVE_CPPFLAGS"
  LIBS="$SAVE_LIBS"

  if test "x$cp_cv_jobmarket_lib" = xyes ; then
    ifelse([$3], , :, [$3])
  else
     JobMarket_CFLAGS=""
     JobMarket_LDFLAGS=""
     JobMarket_LIBS=""
     JobMarket_Controller_LIBS=""
     JobMarket_PoolWorker_LIBS=""
     JobMarket_Server_LIBS=""
     ifelse([$4], , :, [$4])
  fi
  
  AC_SUBST(JobMarket_CFLAGS)
  AC_SUBST(JobMarket_LDFLAGS)
  AC_SUBST(JobMarket_LIBS)
  AC_SUBST(JobMarket_Controller_LIBS)
  AC_SUBST(JobMarket_PoolWorker_LIBS)
  AC_SUBST(JobMarket_Server_LIBS)
])
 
